<?php
namespace Import\ApiBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\Employee;

class ImportCommand extends ContainerAwareCommand
{
    private $Container;
    private $input;
    private $output;

    protected function configure()
    {
        $this
            ->setName('import:all')
            ->setDescription('Import importGPW importInterest importIncomeTaxRates importPaymentMin importPaymentAvg importDelegationCosts importVehicleCosts importContributionZUS')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $timeStart = new \DateTime();
        $this->input = $input;
        $this->output = $output;
        $this->Container = $this->getContainer();

        $this->executeFunction('importGPW');
        $this->executeFunction('importInterest');
        $this->executeFunction('importIncomeTaxRates');
        $this->executeFunction('importPaymentMin');
        $this->executeFunction('importPaymentAvg');
        $this->executeFunction('importDelegationCosts');
        $this->executeFunction('importVehicleCosts');
        $this->executeFunction('importContributionZUS');
        $this->executeFunction('importWibor');

//        $this->loadCVData();

        $timeEnd = new \DateTime();
        $time = $timeEnd->getTimestamp() - $timeStart->getTimestamp();
        $output->writeln('Total time: '.$time.'s');
    }

    private function executeFunction($functionName)
    {
        $start = new \DateTime();
        $this->output->write('<info>'.$functionName.'</info> - ');
        $res = $this->$functionName();
        $end = new \DateTime();
        $this->output->writeln('OK (count='.$res['count'].') - '.($end->getTimestamp() - $start->getTimestamp()).'s');
    }

    private function importGPW()
    {
        $importNewConnect = $this->Container->get('import_gpw');
        return $importNewConnect->import();
    }

    private function importInterest()
    {
        $importInterest = $this->Container->get('import_interest');
        return $importInterest->import();
    }

    private function importIncomeTaxRates()
    {
        $importIncomeTaxRates = $this->Container->get('import_income_tax_rates');
        return $importIncomeTaxRates->import();
    }

    private function importPaymentMin()
    {
        $importMinPayment = $this->Container->get('import_min_payment');
        return $importMinPayment->import();
    }

    private function importPaymentAvg()
    {
        $importAvgPayment = $this->Container->get('import_avg_payment');
        return $importAvgPayment->import();
    }

    private function importDelegationCosts()
    {
        $importDelegationCosts = $this->Container->get('import_delegation_costs');
        return $importDelegationCosts->import();
    }

    private function importVehicleCosts()
    {
        $importVehicleCosts = $this->Container->get('import_vehicle_costs');
        return $importVehicleCosts->import();
    }

    private function importContributionZUS()
    {
        $importContributionZUS = $this->Container->get('import_contribution_ZUS');
        return $importContributionZUS->import();
    }

    private function importWibor()
    {
        $importWibor = $this->Container->get('import_wibor');
        return $importWibor->import();
    }



    protected $url = '../../../../web/CVData.txt';
    public $EntityManager;

    public function loadCVData()
    {
        ini_set('memory_limit', '2048M');
        $this->EntityManager = $this->getContainer()->get('doctrine')->getManager();

        $this->url = __DIR__.'/'.$this->url;

        if(!file_exists($this->url))
        {
            echo 'FILE NOT EXIST: '.$this->url;
            return array();
        }

        $count = 0;
        if (($handle = fopen($this->url, "r", 1)) !== FALSE)
        {
            while (($data = fgets($handle)) !== FALSE)
            {
                $data = explode("\t",$data);
                if(count($data) == 8)
                {

                    $this->createEmployee($data);
                    $count++;
                    if($count % 100 == 0)
                    {
                        $this->EntityManager->flush();
                        $this->EntityManager->clear();
                    }
                    for($i=0;$i<35;$i++)
                    {
                        echo chr(8);
                    }
                    echo "Imort: ".$count." employees.";
                }
            }

            fclose($handle);
        }

        $this->EntityManager->flush();
    }

    private function createEmployee($data)
    {
        $Employee = new Employee();

        $Employee->setName($data[0]);
        $Employee->setSurname($data[1]);
        $Employee->setEducation($data[2]);
        $Employee->setStudies($data[3]);
        $Employee->setDriver($data[4]);
        $Employee->setAge($data[5]);
        $Employee->setSeniority($data[6]);
        $Employee->setSalary($data[7]);
        $Employee->setIsWorker(0);

        $this->EntityManager->persist($Employee);
    }
}